var speed = 6.0;
var jumpSpeed = 8.0;
var gravity = 20.0;

private var moveDirection = Vector3.zero;
private var grounded : boolean = false;
private var haveTheBook : boolean = true;
private var mouseButtonReleased : boolean = true;

public var playerMesh : GameObject = null;
public var bookPrefab : Transform = null;

function FixedUpdate() {
	if (grounded) {
		// We are grounded, so recalculate movedirection directly from axes
		moveDirection = new Vector3(Input.GetAxis("Horizontal"), 0, Input.GetAxis("Vertical"));
		moveDirection = transform.TransformDirection(moveDirection);
		moveDirection *= speed;
		
		if (Input.GetButton ("Jump")) {
			moveDirection.y = jumpSpeed;
		}
		
		if(Mathf.Abs(Input.GetAxis("Vertical")) > 0.1)
		{
			playerMesh.animation.wrapMode = WrapMode.Loop;
			playerMesh.animation["run"].speed = 1.6;
			playerMesh.animation.CrossFade("run");
		}
		else
		{
			playerMesh.animation.wrapMode = WrapMode.Loop;
			playerMesh.animation["idle"].speed = 1.0;
			playerMesh.animation.CrossFade("idle");
		}
		
		if( Input.GetMouseButton( 0 ) )
		{
			if( mouseButtonReleased )
			{
				if( haveTheBook )
				{
					var book : GameObject = GameObject.Find( "book" );
					book.renderer.enabled = false;
					Instantiate( bookPrefab, transform.position, Quaternion.identity );
					haveTheBook = false;
				}
				else
				{
					var knyga : GameObject = GameObject.Find( "knyga(Clone)" );
					var vec : Vector3 = knyga.transform.position - transform.position;
				
					if( vec.magnitude < 0.6 )
					{
						Destroy( knyga );
						haveTheBook = true;
						knyga = GameObject.Find( "book" );
						knyga.renderer.enabled = true;
					}
				}
			}
			
			mouseButtonReleased = false;
		}
		else
		{
			mouseButtonReleased = true;
		}
	}

	// Apply gravity
	moveDirection.y -= gravity * Time.deltaTime;
	
	// Move the controller
	var controller : CharacterController = GetComponent(CharacterController);
	var flags = controller.Move(moveDirection * Time.deltaTime);
	grounded = (flags & CollisionFlags.CollidedBelow) != 0;
}

function Awake()
{
}

@script RequireComponent(CharacterController)